/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.common;

import ibm.nways.jdm.common.IPAddress;
import ibm.nways.jdm.common.OctetString;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.StringTokenizer;

public class OID
implements Serializable {
    public int[] value;
    private int hash;
    private int berLength = -1;

    public OID(int[] nArray) {
        this(nArray, false);
    }

    public OID(OID oID) {
        this.value = new int[oID.value.length];
        int n = this.value.length - 1;
        while (n >= 0) {
            this.value[n] = oID.value[n];
            --n;
        }
        this.hash = oID.hash;
    }

    public OID(int[] nArray, int n) {
        this.hash = 0;
        this.value = new int[n];
        int n2 = 0;
        while (n2 < n) {
            this.value[n2] = nArray[n2];
            this.hash += this.value[n2];
            ++n2;
        }
    }

    public OID(int[] nArray, boolean bl) {
        this.hash = 0;
        if (bl) {
            this.value = nArray;
            int n = this.value.length - 1;
            while (n >= 0) {
                this.hash += this.value[n];
                --n;
            }
            return;
        }
        this.value = new int[nArray.length];
        int n = nArray.length - 1;
        while (n >= 0) {
            this.value[n] = nArray[n];
            this.hash += this.value[n];
            --n;
        }
    }

    public OID(String string) {
        this.hash = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n = stringTokenizer.countTokens();
        this.value = new int[n];
        int n2 = 0;
        while (n2 < n) {
            this.value[n2] = Integer.parseInt(stringTokenizer.nextToken());
            this.hash += this.value[n2];
            ++n2;
        }
    }

    public int getBERlength() {
        if (this.berLength == -1) {
            this.berLength = 1;
            int n = this.value.length;
            int n2 = 2;
            while (n2 < n) {
                int n3 = this.value[n2];
                this.berLength = n3 < 0 ? (this.berLength += 5) : (n3 < 128 ? ++this.berLength : (n3 < 16384 ? (this.berLength += 2) : (n3 < 0x200000 ? (this.berLength += 3) : (n3 < 0x10000000 ? (this.berLength += 4) : (this.berLength += 5)))));
                ++n2;
            }
            return this.berLength;
        }
        return this.berLength;
    }

    public OID concatenate(int n) {
        int n2 = this.value.length;
        int[] nArray = new int[n2 + 1];
        int n3 = 0;
        while (n3 < n2) {
            nArray[n3] = this.value[n3];
            ++n3;
        }
        nArray[n3] = n;
        OID oID = new OID(nArray, true);
        return oID;
    }

    public OID concatenate(String string, boolean bl) {
        int n = this.value.length;
        int n2 = string.length();
        int[] nArray = bl ? new int[n + 1 + n2] : new int[n + n2];
        int n3 = 0;
        while (n3 < n) {
            nArray[n3] = this.value[n3];
            ++n3;
        }
        if (bl) {
            nArray[n3++] = n2;
        }
        int n4 = 0;
        while (n4 < n2) {
            nArray[n3] = string.charAt(n4);
            ++n3;
            ++n4;
        }
        OID oID = new OID(nArray, true);
        return oID;
    }

    public OID concatenate(OctetString octetString, boolean bl) {
        int n = this.value.length;
        int n2 = octetString.value.length;
        int[] nArray = bl ? new int[n + 1 + n2] : new int[n + n2];
        int n3 = 0;
        while (n3 < n) {
            nArray[n3] = this.value[n3];
            ++n3;
        }
        if (bl) {
            nArray[n3++] = n2;
        }
        int n4 = 0;
        while (n4 < n2) {
            nArray[n3] = octetString.value[n4] & 0xFF;
            ++n3;
            ++n4;
        }
        OID oID = new OID(nArray, true);
        return oID;
    }

    public OID concatenate(IPAddress iPAddress) {
        int n = this.value.length;
        byte[] byArray = iPAddress.getBytes();
        int n2 = byArray.length;
        int[] nArray = new int[n + n2];
        int n3 = 0;
        while (n3 < n) {
            nArray[n3] = this.value[n3];
            ++n3;
        }
        int n4 = 0;
        while (n4 < n2) {
            nArray[n3] = byArray[n4] & 0xFF;
            ++n3;
            ++n4;
        }
        OID oID = new OID(nArray, true);
        return oID;
    }

    public OID concatenate(OID oID) {
        return this.concatenate(oID.value);
    }

    public OID concatenate(int[] nArray) {
        if (nArray == null) {
            return this;
        }
        int n = this.value.length;
        int n2 = nArray.length;
        int[] nArray2 = new int[n + n2];
        int n3 = 0;
        while (n3 < n) {
            nArray2[n3] = this.value[n3];
            ++n3;
        }
        int n4 = 0;
        while (n4 < n2) {
            nArray2[n3++] = nArray[n4];
            ++n4;
        }
        OID oID = new OID(nArray2, true);
        return oID;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(String.valueOf(this.value[0]));
        int n = 1;
        while (n < this.value.length) {
            stringBuffer.append(".");
            stringBuffer.append(this.value[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof OID) {
            OID oID = (OID)object;
            boolean bl = true;
            if (this.value.length == oID.value.length) {
                int n = this.value.length - 1;
                while (bl && n >= 0) {
                    bl = this.value[n] == oID.value[n];
                    --n;
                }
            } else {
                bl = false;
            }
            return bl;
        }
        return false;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean startsWith(OID oID) {
        boolean bl = true;
        if (oID.value.length <= this.value.length) {
            int n;
            int n2 = n = oID.value.length - 1;
            while (bl && n2 >= 0) {
                bl = oID.value[n2] == this.value[n2];
                --n2;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public int compareTo(OID oID) {
        int n = 0;
        int n2 = this.value.length;
        if (oID.value.length < n2) {
            n2 = oID.value.length;
        }
        int n3 = 0;
        while (n == 0 && n3 < n2) {
            n = this.value[n3] - oID.value[n3];
            ++n3;
        }
        if (n == 0) {
            n = this.value.length - oID.value.length;
        }
        return n;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.value.length);
        int n = 0;
        while (n < this.value.length) {
            objectOutputStream.writeInt(this.value[n]);
            ++n;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.hash = 0;
        int n = objectInputStream.readInt();
        this.value = new int[n];
        int n2 = 0;
        while (n2 < n) {
            this.value[n2] = objectInputStream.readInt();
            this.hash += this.value[n2];
            ++n2;
        }
        this.berLength = -1;
    }
}

